// osg header files
#include <osg/Node>
#include <osg/Notify>
#include <osg/MatrixTransform>
#include <osgViewer/Viewer>
#include <osgViewer/ViewerEventHandlers>
#include <osgDB/Registry>
#include <osgDB/ReadFile>


/**************************************************************
* ABOUT THIS DEMO-APPLICATION: OSG Usage
* ============================
* This application demonstrates how to use OpenSceneGraph
* within your application. CMake is used to setup all
* important variables (includes / libs / etc.)
***************************************************************/

int main( int argc, char **argv )
{
    /////////////////
    // SCENE SETUP //
    /////////////////
    // load the nodes from the command line arguments.
    osg::ArgumentParser arguments(&argc,argv);
    osg::Node* loadedModel = osgDB::readNodeFiles(arguments);

    // if not loaded assume no arguments passed in, try use default model instead.
    if (!loadedModel) 
        loadedModel = osgDB::readNodeFile("cow.osg");

    if (!loadedModel)
    {
        osg::notify(osg::NOTICE) << "main(): Could not open model \"cow.osg\" scene." << std::endl;
        return 1;
    }

    // create a transform to spin the model.
    osg::MatrixTransform* loadedModelTransform = new osg::MatrixTransform;
    loadedModelTransform->addChild(loadedModel);

    // spin the model automatically 
    osg::NodeCallback* nc = new osg::AnimationPathCallback(
        loadedModelTransform->getBound().center(),
        osg::Vec3(0.0f,0.0f,1.0f),osg::inDegrees(45.0f));
    loadedModelTransform->setUpdateCallback(nc);

    //////////////////
    // VIEWER SETUP //
    //////////////////
    osgViewer::Viewer viewer(arguments);
    viewer.setUpViewInWindow( 50, 50, 640, 480);
    viewer.getCamera()->setClearColor( osg::Vec4(0.15, 0.15, 0.15, 1.0) );
    viewer.setThreadingModel(osgViewer::Viewer::SingleThreaded);

    viewer.setSceneData( loadedModelTransform );
    viewer.addEventHandler(new osgViewer::StatsHandler);

    return viewer.run();
}
